package fr.asip.cps3.exemple.modele.resultats;

/**
 * Classe reprsentant le rsultat de gnration de signature d'un message court
 */
public class ResultatSignatureMessage extends ResultatDouble {

	/**
	 * La signature
	 */
	private String signature;

	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 */
	public ResultatSignatureMessage(String operation1, String operation2){
		this(operation1, operation2, "");
	}
	
	/**
	 * Constructeur
	 * @param operation1 Description de la premire opration
	 * @param operation2 Description de la deuxime opration
	 * @param signature La signature
	 */
	public ResultatSignatureMessage(String operation1, String operation2, String signature){
		super(operation1, operation2);
		this.signature = signature;
	}
	
	/**
	 * Accesseur
	 * @return La signature
	 */
	public String getSignature() {
		return this.signature;
	}

	/**
	 * Mutateur
	 * @param signature La signature
	 */
	public void setSignature(String signature) {
		this.signature = signature;
	}

}
